﻿using System.Collections.Generic;
using System.Linq;
using UnityEngine;
using UnityEngine.Windows.Speech;

public class SpeechManager : MonoBehaviour
{
    KeywordRecognizer keywordRecognizer = null;
    Dictionary<string, System.Action> keywords = new Dictionary<string, System.Action>();

    // Use this for initialization
    void Start()
    {
        print("started");

        keywords.Add("Cube", () =>
        {
            print("selected a cube!");
            SelectTool.selected = "Cube";
        });
        keywords.Add("Sphere", () =>
        {
            print("selected a Sphere!");
            SelectTool.selected = "Sphere";
        });
        keywords.Add("Thick Line", () =>
        {
            print("selected a Line!");
            SelectTool.selected = "Line";
        });
        keywords.Add("Doodle", () =>
        {
            print("selected thinLines!");
            SelectTool.selected = "DrawThinLines";
        });
        keywords.Add("Thin Polylines", () =>
        {
            print("selected Polylines!");
            SelectTool.selected = "Polylines";
        });
        keywords.Add("Thick Polylines", () =>
        {
            print("selected ThickPolylines!");
            SelectTool.selected = "ThickPolylines";
            SimpleShapeManipulation.firstOne = true;
        });
        keywords.Add("Cube From Last Corner", () =>
        {
            print("selected CubeFromSameCorner!");
            SelectTool.selected = "CubeFromSameCorner";
            SimpleShapeManipulation.firstOne = true;
        });
        keywords.Add("Erase All", () =>
        {
            print("selected Erase!");
            SelectTool.selected = "Erase";
            foreach (GameObject obj in SimpleShapeManipulation.Cubes) obj.tag = "";
            foreach (GameObject obj in SimpleShapeManipulation.Spheres) obj.tag = "";
            foreach (GameObject obj in SimpleShapeManipulation.thickLines) obj.tag = "";
            foreach (GameObject obj in SimpleShapeManipulation.thickPolylines) obj.tag = "";
            foreach (GameObject obj in SimpleShapeManipulation.thickPolylinesEnds) obj.tag = "";

            foreach (GameObject obj in SimpleShapeManipulation.Cubes) Destroy(obj);
            foreach (GameObject obj in SimpleShapeManipulation.Spheres) Destroy(obj);
            foreach (GameObject obj in SimpleShapeManipulation.thickLines) Destroy(obj);
            foreach (GameObject obj in SimpleShapeManipulation.thickPolylines) Destroy(obj);
            foreach (GameObject obj in SimpleShapeManipulation.thickPolylinesEnds) Destroy(obj);
        });
        // Tell the KeywordRecognizer about our keywords.
        keywordRecognizer = new KeywordRecognizer(keywords.Keys.ToArray());

        // Register a callback for the KeywordRecognizer and start recognizing!
        keywordRecognizer.OnPhraseRecognized += KeywordRecognizer_OnPhraseRecognized;
        keywordRecognizer.Start();
    }

    private void KeywordRecognizer_OnPhraseRecognized(PhraseRecognizedEventArgs args)
    {
        print("hello");
        System.Action keywordAction;
        if (keywords.TryGetValue(args.text, out keywordAction))
        {
            keywordAction.Invoke();
        }
    }
}